<?php

namespace ZRay;

class MyPlugin
{
	private $zrp = null;

	public function __construct($zrp)
	{
		$this->zrp = $zrp;
	}

	public function leave(array $context, array &$storage)
	{
        static $cnt = 0;

        $name = $context['functionArgs'][0];

        $storage['Params'][] = array(
            '#' => ++$cnt,
            'Name' => $name
        );

        $storage['Info'][] = array(
            '#' => $cnt,
            'Duration inclusive (ms)' => $context['durationInclusive'] / 1000,
            'Duration exclusive (ms)' => $context['durationExclusive'] / 1000
        );
    }

}

$zrp = new \ZRayPlugin("MyClass");

$my = new MyPlugin($zrp);

$zrp->traceFunction('MyClass::hello', null, array($my, 'leave'));

$zrp->setEnabledAfter('MyClass::__construct');
