--TEST--
bcdiv() function with large numbers
--EXTENSIONS--
bcmath
--INI--
bcmath.scale=0
--FILE--
<?php
require(__DIR__ . "/run_bcmath_tests_function.inc");

$dividends = [
    "15151324141414.412312232141241",
    "-132132245132134.1515123765412",
    "141241241241241248267654747412",
    "-149143276547656984948124912",
    "0.1322135476547459213732911312",
    "-0.123912932193769965476541321",
];
$divisors = array_merge($dividends, [
    "15",
    "-15",
    "1",
    "-9",
    "14.14",
    "-16.60",
    "0.15",
    "-0.01",
]);

run_bcmath_tests($dividends, $divisors, "/", bcdiv(...));

?>
--EXPECT--
Number "15151324141414.412312232141241" (scale 0)
15151324141414.412312232141241 / 15151324141414.412312232141241 = 1
15151324141414.412312232141241 / -132132245132134.1515123765412 = 0
15151324141414.412312232141241 / 141241241241241248267654747412 = 0
15151324141414.412312232141241 / -149143276547656984948124912   = 0
15151324141414.412312232141241 / 0.1322135476547459213732911312 = 114597364719231
15151324141414.412312232141241 / -0.123912932193769965476541321 = -122273953760705
15151324141414.412312232141241 / 15                             = 1010088276094
15151324141414.412312232141241 / -15                            = -1010088276094
15151324141414.412312232141241 / 1                              = 15151324141414
15151324141414.412312232141241 / -9                             = -1683480460157
15151324141414.412312232141241 / 14.14                          = 1071522216507
15151324141414.412312232141241 / -16.60                         = -912730369964
15151324141414.412312232141241 / 0.15                           = 101008827609429
15151324141414.412312232141241 / -0.01                          = -1515132414141441

Number "-132132245132134.1515123765412" (scale 0)
-132132245132134.1515123765412 / 15151324141414.412312232141241 = -8
-132132245132134.1515123765412 / -132132245132134.1515123765412 = 1
-132132245132134.1515123765412 / 141241241241241248267654747412 = 0
-132132245132134.1515123765412 / -149143276547656984948124912   = 0
-132132245132134.1515123765412 / 0.1322135476547459213732911312 = -999385066628541
-132132245132134.1515123765412 / -0.123912932193769965476541321 = 1066331356968545
-132132245132134.1515123765412 / 15                             = -8808816342142
-132132245132134.1515123765412 / -15                            = 8808816342142
-132132245132134.1515123765412 / 1                              = -132132245132134
-132132245132134.1515123765412 / -9                             = 14681360570237
-132132245132134.1515123765412 / 14.14                          = -9344571791522
-132132245132134.1515123765412 / -16.60                         = 7959773803140
-132132245132134.1515123765412 / 0.15                           = -880881634214227
-132132245132134.1515123765412 / -0.01                          = 13213224513213415

Number "141241241241241248267654747412" (scale 0)
141241241241241248267654747412 / 15151324141414.412312232141241 = 9322039441765651
141241241241241248267654747412 / -132132245132134.1515123765412 = -1068938479778330
141241241241241248267654747412 / 141241241241241248267654747412 = 1
141241241241241248267654747412 / -149143276547656984948124912   = -947
141241241241241248267654747412 / 0.1322135476547459213732911312 = 1068281153835079546834811315187
141241241241241248267654747412 / -0.123912932193769965476541321 = -1139842619657922251471288994015
141241241241241248267654747412 / 15                             = 9416082749416083217843649827
141241241241241248267654747412 / -15                            = -9416082749416083217843649827
141241241241241248267654747412 / 1                              = 141241241241241248267654747412
141241241241241248267654747412 / -9                             = -15693471249026805363072749712
141241241241241248267654747412 / 14.14                          = 9988772365009989269282513961
141241241241241248267654747412 / -16.60                         = -8508508508508508931786430566
141241241241241248267654747412 / 0.15                           = 941608274941608321784364982746
141241241241241248267654747412 / -0.01                          = -14124124124124124826765474741200

Number "-149143276547656984948124912" (scale 0)
-149143276547656984948124912 / 15151324141414.412312232141241 = -9843580346881
-149143276547656984948124912 / -132132245132134.1515123765412 = 1128742468566
-149143276547656984948124912 / 141241241241241248267654747412 = 0
-149143276547656984948124912 / -149143276547656984948124912   = 1
-149143276547656984948124912 / 0.1322135476547459213732911312 = -1128048367154629906735882014
-149143276547656984948124912 / -0.123912932193769965476541321 = 1203613488174364568320268735
-149143276547656984948124912 / 15                             = -9942885103177132329874994
-149143276547656984948124912 / -15                            = 9942885103177132329874994
-149143276547656984948124912 / 1                              = -149143276547656984948124912
-149143276547656984948124912 / -9                             = 16571475171961887216458323
-149143276547656984948124912 / 14.14                          = -10547615031658909826600064
-149143276547656984948124912 / -16.60                         = 8984534731786565358320777
-149143276547656984948124912 / 0.15                           = -994288510317713232987499413
-149143276547656984948124912 / -0.01                          = 14914327654765698494812491200

Number "0.1322135476547459213732911312" (scale 0)
0.1322135476547459213732911312 / 15151324141414.412312232141241 = 0
0.1322135476547459213732911312 / -132132245132134.1515123765412 = 0
0.1322135476547459213732911312 / 141241241241241248267654747412 = 0
0.1322135476547459213732911312 / -149143276547656984948124912   = 0
0.1322135476547459213732911312 / 0.1322135476547459213732911312 = 1
0.1322135476547459213732911312 / -0.123912932193769965476541321 = -1
0.1322135476547459213732911312 / 15                             = 0
0.1322135476547459213732911312 / -15                            = 0
0.1322135476547459213732911312 / 1                              = 0
0.1322135476547459213732911312 / -9                             = 0
0.1322135476547459213732911312 / 14.14                          = 0
0.1322135476547459213732911312 / -16.60                         = 0
0.1322135476547459213732911312 / 0.15                           = 0
0.1322135476547459213732911312 / -0.01                          = -13

Number "-0.123912932193769965476541321" (scale 0)
-0.123912932193769965476541321 / 15151324141414.412312232141241 = 0
-0.123912932193769965476541321 / -132132245132134.1515123765412 = 0
-0.123912932193769965476541321 / 141241241241241248267654747412 = 0
-0.123912932193769965476541321 / -149143276547656984948124912   = 0
-0.123912932193769965476541321 / 0.1322135476547459213732911312 = 0
-0.123912932193769965476541321 / -0.123912932193769965476541321 = 1
-0.123912932193769965476541321 / 15                             = 0
-0.123912932193769965476541321 / -15                            = 0
-0.123912932193769965476541321 / 1                              = 0
-0.123912932193769965476541321 / -9                             = 0
-0.123912932193769965476541321 / 14.14                          = 0
-0.123912932193769965476541321 / -16.60                         = 0
-0.123912932193769965476541321 / 0.15                           = 0
-0.123912932193769965476541321 / -0.01                          = 12

Number "15151324141414.412312232141241" (scale 10)
15151324141414.412312232141241 / 15151324141414.412312232141241 = 1.0000000000
15151324141414.412312232141241 / -132132245132134.1515123765412 = -0.1146678778
15151324141414.412312232141241 / 141241241241241248267654747412 = 0.0000000000
15151324141414.412312232141241 / -149143276547656984948124912   = 0.0000000000
15151324141414.412312232141241 / 0.1322135476547459213732911312 = 114597364719231.4957119169
15151324141414.412312232141241 / -0.123912932193769965476541321 = -122273953760705.0772823300
15151324141414.412312232141241 / 15                             = 1010088276094.2941541488
15151324141414.412312232141241 / -15                            = -1010088276094.2941541488
15151324141414.412312232141241 / 1                              = 15151324141414.4123122321
15151324141414.412312232141241 / -9                             = -1683480460157.1569235813
15151324141414.412312232141241 / 14.14                          = 1071522216507.3841804973
15151324141414.412312232141241 / -16.60                         = -912730369964.7236332669
15151324141414.412312232141241 / 0.15                           = 101008827609429.4154148809
15151324141414.412312232141241 / -0.01                          = -1515132414141441.2312232141

Number "-132132245132134.1515123765412" (scale 10)
-132132245132134.1515123765412 / 15151324141414.412312232141241 = -8.7208381194
-132132245132134.1515123765412 / -132132245132134.1515123765412 = 1.0000000000
-132132245132134.1515123765412 / 141241241241241248267654747412 = 0.0000000000
-132132245132134.1515123765412 / -149143276547656984948124912   = 0.0000000000
-132132245132134.1515123765412 / 0.1322135476547459213732911312 = -999385066628541.8940917146
-132132245132134.1515123765412 / -0.123912932193769965476541321 = 1066331356968545.9568177107
-132132245132134.1515123765412 / 15                             = -8808816342142.2767674917
-132132245132134.1515123765412 / -15                            = 8808816342142.2767674917
-132132245132134.1515123765412 / 1                              = -132132245132134.1515123765
-132132245132134.1515123765412 / -9                             = 14681360570237.1279458196
-132132245132134.1515123765412 / 14.14                          = -9344571791522.9244351044
-132132245132134.1515123765412 / -16.60                         = 7959773803140.6115368901
-132132245132134.1515123765412 / 0.15                           = -880881634214227.6767491769
-132132245132134.1515123765412 / -0.01                          = 13213224513213415.1512376541

Number "141241241241241248267654747412" (scale 10)
141241241241241248267654747412 / 15151324141414.412312232141241 = 9322039441765651.5733487418
141241241241241248267654747412 / -132132245132134.1515123765412 = -1068938479778330.9382445997
141241241241241248267654747412 / 141241241241241248267654747412 = 1.0000000000
141241241241241248267654747412 / -149143276547656984948124912   = -947.0171536435
141241241241241248267654747412 / 0.1322135476547459213732911312 = 1068281153835079546834811315187.2460414102
141241241241241248267654747412 / -0.123912932193769965476541321 = -1139842619657922251471288994015.5745430452
141241241241241248267654747412 / 15                             = 9416082749416083217843649827.4666666666
141241241241241248267654747412 / -15                            = -9416082749416083217843649827.4666666666
141241241241241248267654747412 / 1                              = 141241241241241248267654747412.0000000000
141241241241241248267654747412 / -9                             = -15693471249026805363072749712.4444444444
141241241241241248267654747412 / 14.14                          = 9988772365009989269282513961.2446958981
141241241241241248267654747412 / -16.60                         = -8508508508508508931786430566.9879518072
141241241241241248267654747412 / 0.15                           = 941608274941608321784364982746.6666666666
141241241241241248267654747412 / -0.01                          = -14124124124124124826765474741200.0000000000

Number "-149143276547656984948124912" (scale 10)
-149143276547656984948124912 / 15151324141414.412312232141241 = -9843580346881.4246956668
-149143276547656984948124912 / -132132245132134.1515123765412 = 1128742468566.3333472319
-149143276547656984948124912 / 141241241241241248267654747412 = -0.0010559470
-149143276547656984948124912 / -149143276547656984948124912   = 1.0000000000
-149143276547656984948124912 / 0.1322135476547459213732911312 = -1128048367154629906735882014.2432613477
-149143276547656984948124912 / -0.123912932193769965476541321 = 1203613488174364568320268735.7225301437
-149143276547656984948124912 / 15                             = -9942885103177132329874994.1333333333
-149143276547656984948124912 / -15                            = 9942885103177132329874994.1333333333
-149143276547656984948124912 / 1                              = -149143276547656984948124912.0000000000
-149143276547656984948124912 / -9                             = 16571475171961887216458323.5555555555
-149143276547656984948124912 / 14.14                          = -10547615031658909826600064.4978783592
-149143276547656984948124912 / -16.60                         = 8984534731786565358320777.8313253012
-149143276547656984948124912 / 0.15                           = -994288510317713232987499413.3333333333
-149143276547656984948124912 / -0.01                          = 14914327654765698494812491200.0000000000

Number "0.1322135476547459213732911312" (scale 10)
0.1322135476547459213732911312 / 15151324141414.412312232141241 = 0.0000000000
0.1322135476547459213732911312 / -132132245132134.1515123765412 = 0.0000000000
0.1322135476547459213732911312 / 141241241241241248267654747412 = 0.0000000000
0.1322135476547459213732911312 / -149143276547656984948124912   = 0.0000000000
0.1322135476547459213732911312 / 0.1322135476547459213732911312 = 1.0000000000
0.1322135476547459213732911312 / -0.123912932193769965476541321 = -1.0669874831
0.1322135476547459213732911312 / 15                             = 0.0088142365
0.1322135476547459213732911312 / -15                            = -0.0088142365
0.1322135476547459213732911312 / 1                              = 0.1322135476
0.1322135476547459213732911312 / -9                             = -0.0146903941
0.1322135476547459213732911312 / 14.14                          = 0.0093503216
0.1322135476547459213732911312 / -16.60                         = -0.0079646715
0.1322135476547459213732911312 / 0.15                           = 0.8814236510
0.1322135476547459213732911312 / -0.01                          = -13.2213547654

Number "-0.123912932193769965476541321" (scale 10)
-0.123912932193769965476541321 / 15151324141414.412312232141241 = 0.0000000000
-0.123912932193769965476541321 / -132132245132134.1515123765412 = 0.0000000000
-0.123912932193769965476541321 / 141241241241241248267654747412 = 0.0000000000
-0.123912932193769965476541321 / -149143276547656984948124912   = 0.0000000000
-0.123912932193769965476541321 / 0.1322135476547459213732911312 = -0.9372181171
-0.123912932193769965476541321 / -0.123912932193769965476541321 = 1.0000000000
-0.123912932193769965476541321 / 15                             = -0.0082608621
-0.123912932193769965476541321 / -15                            = 0.0082608621
-0.123912932193769965476541321 / 1                              = -0.1239129321
-0.123912932193769965476541321 / -9                             = 0.0137681035
-0.123912932193769965476541321 / 14.14                          = -0.0087632908
-0.123912932193769965476541321 / -16.60                         = 0.0074646344
-0.123912932193769965476541321 / 0.15                           = -0.8260862146
-0.123912932193769965476541321 / -0.01                          = 12.3912932193
