// Protocol Buffers - Google's data interchange format
// Copyright 2023 Google LLC.  All rights reserved.
//
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file or at
// https://developers.google.com/open-source/licenses/bsd

//! Kernel-agnostic logic for the Rust Protobuf runtime that should not be
//! exposed to through the `protobuf` path but must be public for use by
//! generated code.

// Used by the proto! macro
pub use paste::paste;

pub use crate::r#enum::Enum;
pub use crate::ProtoStr;
pub use std::fmt::Debug;

// TODO: Temporarily re-export these symbols which are now under
// __runtime under __internal since some external callers using it through
// __internal.
pub use crate::__runtime::{PtrAndLen, RawMap, RawMessage, RawRepeatedField};

/// Used to protect internal-only items from being used accidentally.
#[derive(Debug)]
pub struct Private;

/// A trait that is used as a subtrait of traits that we intend to be used but
/// not be implemented by users.
///
/// This is slightly less 'sealed' than the typical sealed trait pattern would
/// permit in other crates; this trait is intended to be available to crates
/// which were generated by protoc, but not to application code.
pub trait SealedInternal {}

/// A trait used by the proto_eq() gtest macro.
pub trait MatcherEq: SealedInternal + Debug {
    fn matches(&self, o: &Self) -> bool;
}
